
getwd()
setwd("D:/R work")


install.packages("glmnet")

library(glmnet)
library(Matrix)
library(rms)
library(foreign)
library(readr)


mydata<-na.omit(mydata)


dev = mydata[mydata$Set==1,]


install.packages("psych")

library(psych)

View(dev)


x <- as.matrix(data.frame(dev[,c(1:22)]))


y <- as.matrix(dev[,23])

fit<-glmnet(x,y,alpha=1,family='binomial')

plot(fit)


plot(fit, xvar = "lambda", label = TRUE)
plot(fit, xvar = "lambda", label = FALSE)

abline(v=log(c(cv.fit$lambda.min,cv.fit$lambda.1se)),lty=3)  
print(fit)



dev$lassopred <-predict(fit,type="response",newx=x[1:4622,],s=0.000761) 

View(dev)



set.seed(123)
cv.fit <- cv.glmnet(x,y,alpha=1,nfolds = 10)
plot(cv.fit)
abline(v=log(c(cv.fit$lambda.min,cv.fit$lambda.1se)),lty=3)


cv.fit$lambda.min
Coefficients <- coef(fit, s = cv.fit$lambda.min)
Active.Index <- which(Coefficients != 0)
Active.Coefficients <- Coefficients[Active.Index]
Active.Index
Active.Coefficients
row.names(Coefficients)[Active.Index]
dev$minlassopred <-predict(fit,type="response",newx=x[1:4622,],s=cv.fit$lambda.min)  #x[1:685,]685代表咱dev中的样本量或记录数


cv.fit$lambda.1se
Coefficients <- coef(fit, s = cv.fit$lambda.1se)
Active.Index <- which(Coefficients != 0)
Active.Coefficients <- Coefficients[Active.Index]
Active.Index
Active.Coefficients
row.names(Coefficients)[Active.Index]
ml<-data.frame( 
  'Coefficients'=Active.Coefficients,
  'names'=row.names(Coefficients)[Active.Index]
  )[-1,] 
library(ggplot2)
ggplot(p,aes(x=risk,y=OR,
                fill=OR))+
  geom_bar(stat='identity')+
  labs(x=NULL)+
  theme_bw(base_size=18)+
  theme(axis.text=element_text(colour='black'),
        legend.position='none')
dev$selassopred <-predict(fit,type="response",newx=x[1:4622,],s=cv.fit$lambda.1se)
write.csv(ml, "mul.csv")



library(pROC)

devmodelA <- roc(PH~minlassopred, data = dev,smooth=F)

devmodelA

round(auc(devmodelA),3)
round(ci(auc(devmodelA)),3)



plot(devmodelA, print.auc=TRUE, print.thres=TRUE,main = "ROC CURVE", 
     col= "blue",print.thres.col="blue",identity.col="blue",
     identity.lty=1,identity.lwd=1)


devroc1 <- plot.roc(dev$PH2, dev$lassopred, main="dev ROC", percent=TRUE, col="blue")
devroc2 <- lines.roc(dev$PH2, dev$minlassopred, percent=TRUE, col="green")
devroc3 <- lines.roc(dev$PH2, dev$selassopred, percent=TRUE, col="red")
legend("bottomright", legend=c("lassopred", "minlassopred","selassopred"), col=c("blue", "green","red"), lwd=2)




